/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.reset;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.ResetDomainsInterface;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.ClockAndResetDomainUtils;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.yosys.objects.YosysClockOrResetDomain;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsPort;
import com.lintyservices.yosys.objects.YosysResetDomain;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ResetDomains
implements ResetDomainsInterface {
    private final ClockAndResetDomainUtils clockAndResetDomainUtils;
    @Nullable
    private final YosysResetManagementModule resetManagementModule;
    private final List<YosysResetDomain> sortedGlobalResetDomains;
    private final List<YosysResetDomain> sortedSimpleGlobalResetDomains;
    private final List<YosysResetDomain> sortedComplexGlobalResetDomains;
    private final List<YosysResetDomain> sortedSimpleLocalResetDomains;
    private final List<YosysResetDomain> sortedComplexLocalResetDomains;
    private final List<YosysResetDomain> sortedAllResetDomains;

    public ResetDomains(Set<YosysResetDomain> resetDomainSet, @Nullable YosysResetManagementModule resetManagementModule, ClockAndResetDomainUtils clockAndResetDomainUtils) {
        this.clockAndResetDomainUtils = clockAndResetDomainUtils;
        this.resetManagementModule = resetManagementModule;
        this.sortedSimpleGlobalResetDomains = resetDomainSet.stream().filter(d -> d.origins().size() == 1).filter(YosysResetDomain::global).sorted(Comparator.comparing(d -> ((YosysResetDomain)d).origins().get(0) instanceof YosysResetClockDomainOriginAsPort).thenComparingInt(d -> ((YosysResetDomain)d).modules()).thenComparingInt(d -> ((YosysResetDomain)d).flipFlops())).collect(Collectors.toList());
        Collections.reverse(this.sortedSimpleGlobalResetDomains);
        this.sortedComplexGlobalResetDomains = resetDomainSet.stream().filter(d -> d.origins().size() > 1).filter(YosysResetDomain::global).sorted(Comparator.comparingInt(YosysClockOrResetDomain::modules).thenComparingInt(YosysClockOrResetDomain::flipFlops)).collect(Collectors.toList());
        Collections.reverse(this.sortedComplexGlobalResetDomains);
        this.sortedSimpleLocalResetDomains = resetDomainSet.stream().filter(d -> d.origins().size() == 1).filter(d -> d.global() == false).sorted(Comparator.comparing(d -> ((YosysResetDomain)d).origins().get(0) instanceof YosysResetClockDomainOriginAsPort).thenComparingInt(d -> ((YosysResetDomain)d).modules()).thenComparingInt(d -> ((YosysResetDomain)d).flipFlops())).collect(Collectors.toList());
        Collections.reverse(this.sortedSimpleLocalResetDomains);
        this.sortedComplexLocalResetDomains = resetDomainSet.stream().filter(d -> d.origins().size() > 1).filter(d -> d.global() == false).sorted(Comparator.comparingInt(YosysClockOrResetDomain::modules).thenComparingInt(YosysClockOrResetDomain::flipFlops)).collect(Collectors.toList());
        Collections.reverse(this.sortedComplexLocalResetDomains);
        this.sortedGlobalResetDomains = Stream.of(this.sortedSimpleGlobalResetDomains, this.sortedComplexGlobalResetDomains).flatMap(Collection::stream).toList();
        this.sortedAllResetDomains = Stream.of(this.sortedGlobalResetDomains, this.sortedSimpleLocalResetDomains, this.sortedComplexLocalResetDomains).flatMap(Collection::stream).toList();
    }

    public int size() {
        return this.allResetDomains().size();
    }

    public int numberOfGlobalResetDomains() {
        return this.sortedGlobalResetDomains.size();
    }

    public int numberOfLocalResetDomains() {
        return this.sortedSimpleLocalResetDomains.size() + this.sortedComplexLocalResetDomains.size();
    }

    public List<YosysResetDomain> globalResetDomains() {
        return this.sortedGlobalResetDomains;
    }

    public List<YosysResetDomain> simpleGlobalResetDomains() {
        return this.sortedSimpleGlobalResetDomains;
    }

    public List<YosysResetDomain> complexGlobalResetDomains() {
        return this.sortedComplexGlobalResetDomains;
    }

    public List<YosysResetDomain> simpleLocalResetDomains() {
        return this.sortedSimpleLocalResetDomains;
    }

    public List<YosysResetDomain> complexLocalResetDomains() {
        return this.sortedComplexLocalResetDomains;
    }

    public List<YosysResetDomain> allResetDomains() {
        return this.sortedAllResetDomains;
    }

    @Nullable
    public YosysResetManagementModule resetManagementModule() {
        return this.resetManagementModule;
    }

    public List<List<? extends IssueLocationInterface>> flows() {
        ArrayList<List<? extends IssueLocationInterface>> flows = new ArrayList<List<? extends IssueLocationInterface>>();
        for (YosysResetDomain resetDomain : this.sortedGlobalResetDomains) {
            flows.add(this.clockAndResetDomainUtils.originLocations(resetDomain));
        }
        return flows;
    }

    public ClockAndResetDomainUtils clockAndResetDomainUtils() {
        return this.clockAndResetDomainUtils;
    }
}

