/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.verific;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderVerificLogAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.SynthesisFilesToAnalyzeAwareVisitor;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.VerificLogItem;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrossFileVerificLogCheck
extends CrossFileBugFinderCheck
implements BugFinderVerificLogAwareVisitor,
SynthesisFilesToAnalyzeAwareVisitor {
    public static final Logger LOG = LoggerFactory.getLogger(CrossFileVerificLogCheck.class);
    private Set<VerificLogItem> items;
    private Set<File> filesToAnalyze;

    public Set<VerificLogItem> items() {
        return this.items;
    }

    @Override
    public void setVerificLogItems(Set<VerificLogItem> items) {
        this.items = items;
    }

    @Override
    public void setSynthesisFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    public void retrieveIssuesFrom(String ruleId, String message) {
        for (VerificLogItem item : this.filteredItems(ruleId)) {
            this.issues().addPreciseIssue(item.location(), message);
        }
    }

    public Set<VerificLogItem> filteredItems(Set<String> ruleIds) {
        return this.items().stream().filter(i -> ruleIds.contains(i.id())).filter(i -> FileUtils.contains(this.filesToAnalyze, i.location().file())).collect(Collectors.toSet());
    }

    public Set<VerificLogItem> filteredItems(String ruleId) {
        return this.filteredItems(Set.of(ruleId));
    }

    public void logMessageCannotBeCustomized(String lintyId, VerificLogItem logItem) {
        LOG.warn("Default message cannot be customized for rule " + lintyId + ".\nPlease, report the following to support@linty-services.com to improve the rule:\n----------\nLinty ID: " + lintyId + "\nVerific ID: " + logItem.id() + "\nMessage: " + logItem.message() + "\n----------\n");
    }
}

