/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class FileIssue
implements IssueInterface {
    private final Check check;
    private final File file;
    private final String message;
    private final List<IssueLocation> secondaryLocations;
    private Double cost;

    public FileIssue(Check check2, File file, String message) {
        this.check = check2;
        this.file = file;
        this.message = message;
        this.secondaryLocations = new ArrayList<IssueLocation>();
        this.cost = null;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Check check() {
        return this.check;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public int line() {
        return -1;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public IssueInterface cost(double cost) {
        this.cost = cost;
        return this;
    }

    public List<IssueLocation> secondaryLocations() {
        return this.secondaryLocations;
    }

    public FileIssue secondary(Tree tree, String message) {
        this.secondaryLocations.add(new IssueLocation(this.file, tree, message));
        return this;
    }

    public FileIssue secondary(File file, Tree tree, String message) {
        this.secondaryLocations.add(new IssueLocation(file, tree, message));
        return this;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(String.format("Rule class: %s%nFile Path: %s%n", this.check.getClass(), this.file.getAbsolutePath()));
        if (!this.secondaryLocations.isEmpty()) {
            output.append("Secondary Locations:\n");
            for (IssueLocation secondaryLocation : this.secondaryLocations) {
                output.append(secondaryLocation);
            }
        }
        return output.toString();
    }
}

