/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.utils.FileUtils;
import java.io.File;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public class IssueLocation
implements Comparable<IssueLocation>,
IssueLocationInterface {
    @Nullable
    private final File file;
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;
    @Nullable
    private String message;
    @Nullable
    private Tree firstTree;
    @Nullable
    private Tree lastTree;

    public IssueLocation(Tree tree) {
        this(null, tree, tree, null);
    }

    public IssueLocation(Tree tree, String message) {
        this(null, tree, tree, message);
    }

    public IssueLocation(@Nullable File file, Tree tree, @Nullable String message) {
        this(file, tree, tree, message);
    }

    public IssueLocation(File file, int startLine, @Nullable String message) {
        this.file = file;
        this.startLine = startLine;
        this.endLine = startLine;
        this.startColumn = -1;
        this.endColumn = -1;
        this.message = message;
    }

    public IssueLocation(File file, int startLine, int startColumn, int endLine, int endColumn, @Nullable String message) {
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.message = message;
    }

    public IssueLocation(File file, int startLine, int startColumn, int endLine, int endColumn) {
        this(file, startLine, startColumn, endLine, endColumn, null);
    }

    public IssueLocation(IssueLocationInterface location, String message) {
        this(location.file(), location.startLine(), location.startColumn(), location.endLine(), location.endColumn(), message);
    }

    public IssueLocation(@Nullable File file, Tree firstTree, Tree lastTree, @Nullable String message) {
        this.file = file;
        this.message = message;
        this.firstTree = firstTree;
        this.lastTree = lastTree;
        this.startLine = firstTree.line();
        this.startColumn = firstTree.column();
        this.endLine = lastTree.endLine();
        this.endColumn = lastTree.endColumn();
    }

    @Override
    @Nullable
    public File file() {
        return this.file;
    }

    @Override
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    public int startLine() {
        return this.startLine;
    }

    @Override
    public int startColumn() {
        return this.startColumn;
    }

    @Override
    public int endLine() {
        return this.endLine;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    @Nullable
    public Tree firstTree() {
        return this.firstTree;
    }

    @Override
    public boolean isLineLocation() {
        return this.startColumn == -1;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String markdown(Configuration config) {
        return this.markdown(config, null);
    }

    public String markdown(Configuration config, @Nullable String message) {
        String path = FileUtils.markdownPath(this.file, (String)config.get("sonar.projectBaseDir").get());
        String display = Objects.requireNonNullElseGet(message, () -> this.file.getName() + "#" + this.startLine);
        String link = String.format("%s#%s", path, this.startLine);
        return String.format("<linty-anchor href=\"/%s\">%s</linty-anchor>", link, display);
    }

    public String markdownWithLocationDisplay(Configuration config, String message) {
        String display = " " + this.file.getName() + "#" + this.startLine + " (" + message + ")";
        return this.markdown(config, display);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueLocation)) {
            return false;
        }
        IssueLocation il = (IssueLocation)o;
        return (il.file != null ? il.file.getAbsolutePath().equals(this.file.getAbsolutePath()) : this.file == null) && Objects.equals(il.firstTree, this.firstTree) && Objects.equals(il.lastTree, this.lastTree) && il.startLine == this.startLine && il.startColumn == this.startColumn && il.endLine == this.endLine && il.endColumn == this.endColumn && Objects.equals(il.message, this.message);
    }

    public int hashCode() {
        int result = 17;
        if (this.file != null) {
            result = 31 * result + this.file.hashCode();
        }
        if (this.message != null) {
            result = 31 * result + this.message.hashCode();
        }
        if (this.firstTree != null) {
            result = 31 * result + this.firstTree.hashCode();
        }
        if (this.lastTree != null) {
            result = 31 * result + this.lastTree.hashCode();
        }
        result = 31 * result + this.startLine;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endColumn;
        return result;
    }

    @Override
    public int compareTo(IssueLocation il) {
        return Comparator.comparing(IssueLocation::startLine).thenComparing(IssueLocation::startColumn).compare(this, il);
    }

    public String toString() {
        return "- Message: %s\n- File Path: %s\n- Begin Line: %d\n- Begin Column: %d\n- End Line: %d\n- End Column: %d\n".formatted(this.message, this.file != null ? this.file.getAbsolutePath() : "Undefined", this.startLine, this.startColumn, this.endLine, this.endColumn);
    }
}

