/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.FileIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.LineIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.LineIssueWithFlows;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssueWithFlows;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Issues {
    private final Check check;
    private List<IssueInterface> allIssues;

    public Issues(Check check2) {
        this.check = check2;
        this.allIssues = new ArrayList<IssueInterface>();
    }

    public void addPreciseIssue(File file, Tree tree, String message) {
        PreciseIssue issue = new PreciseIssue(this.check, new IssueLocation(file, tree, message));
        this.allIssues.add(issue);
    }

    public void addPreciseIssue(File file, Tree tree, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        PreciseIssue issue = new PreciseIssue(this.check, new IssueLocation(file, tree, message), secondaryLocations);
        this.allIssues.add(issue);
    }

    public void addPreciseIssue(IssueLocation issueLocation) {
        PreciseIssue issue = new PreciseIssue(this.check, issueLocation);
        this.allIssues.add(issue);
    }

    public void addPreciseIssue(IssueLocation location, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        PreciseIssue issue = new PreciseIssue(this.check, new IssueLocation(location, message), secondaryLocations);
        this.allIssues.add(issue);
    }

    public void addPreciseIssue(IssueLocation location, List<? extends IssueLocationInterface> secondaryLocations) {
        PreciseIssue issue = new PreciseIssue(this.check, location, secondaryLocations);
        this.allIssues.add(issue);
    }

    public void addPreciseIssueWithFlows(File file, Tree tree, String message, List<List<? extends IssueLocationInterface>> flows) {
        PreciseIssueWithFlows issue = new PreciseIssueWithFlows(this.check, new IssueLocation(file, tree, message), flows);
        this.allIssues.add(issue);
    }

    public void addPreciseIssueWithFlows(IssueLocation location, String message, List<List<? extends IssueLocationInterface>> flows) {
        PreciseIssueWithFlows issue = new PreciseIssueWithFlows(this.check, new IssueLocation(location, message), flows);
        this.allIssues.add(issue);
    }

    public void addPreciseIssueWithFlows(IssueLocation primaryLocation, List<List<? extends IssueLocationInterface>> flows) {
        PreciseIssueWithFlows issue = new PreciseIssueWithFlows(this.check, primaryLocation, flows);
        this.allIssues.add(issue);
    }

    public void addFileIssue(File file, String message) {
        FileIssue issue = new FileIssue(this.check, file, message);
        this.allIssues.add(issue);
    }

    public void addLineIssue(File file, int line, String message) {
        LineIssue issue = new LineIssue(this.check, file, line, message);
        this.allIssues.add(issue);
    }

    public void addLineIssue(File file, int line, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        LineIssue issue = new LineIssue(this.check, file, line, message, secondaryLocations);
        this.allIssues.add(issue);
    }

    public void addLineIssueWithFlows(File file, int line, String message, List<List<? extends IssueLocationInterface>> flows) {
        LineIssueWithFlows issue = new LineIssueWithFlows(this.check, file, line, message, flows);
        this.allIssues.add(issue);
    }

    public void addPreciseIssues(Set<PreciseIssue> allIssues) {
        this.allIssues.addAll(allIssues);
    }

    public List<IssueInterface> allIssues() {
        return this.allIssues;
    }

    public Check check() {
        return this.check;
    }

    public void reset() {
        this.allIssues.clear();
    }

    public void filterIssues(Set<File> filesToAnalyse) {
        this.allIssues = this.allIssues.stream().filter(i -> FileUtils.contains(filesToAnalyse, i.file())).toList();
    }
}

