/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;

public class PreciseIssueWithFlows
implements IssueInterface {
    private final Check check;
    private final IssueLocation primaryLocation;
    private final List<List<? extends IssueLocationInterface>> flows;
    private Double cost;

    public PreciseIssueWithFlows(Check check2, IssueLocation primaryLocation, List<List<? extends IssueLocationInterface>> flows) {
        this.check = check2;
        this.primaryLocation = primaryLocation;
        this.flows = flows;
        this.cost = null;
    }

    @Override
    public Check check() {
        return this.check;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public PreciseIssueWithFlows cost(double cost) {
        this.cost = cost;
        return this;
    }

    @Override
    public String message() {
        return this.primaryLocation.message();
    }

    @Override
    public File file() {
        return this.primaryLocation.file();
    }

    @Override
    public int line() {
        return this.primaryLocation.startLine();
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<List<? extends IssueLocationInterface>> flows() {
        return this.flows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreciseIssueWithFlows)) {
            return false;
        }
        PreciseIssueWithFlows p = (PreciseIssueWithFlows)o;
        return p.check.getClass().equals(this.check.getClass()) && p.primaryLocation.equals(this.primaryLocation);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.check.getClass().hashCode();
        result = 31 * result + this.primaryLocation.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(String.format("Rule class: %s%nPrimary Location:%n%s%n", this.check.getClass(), this.primaryLocation));
        if (!this.flows.isEmpty()) {
            output.append("Flow Locations:\n");
            for (int i = 0; i < this.flows.size(); ++i) {
                output.append("Flow #");
                output.append(i);
                for (IssueLocationInterface issueLocationInterface : this.flows.get(i)) {
                    output.append(issueLocationInterface);
                }
            }
        }
        return output.toString();
    }
}

