/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.diagnostic;

import com.lintyservices.slang.helpers.Diagnostic;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangDiagnosticCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Diagnostics;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VERILOG2124")
public class ParsingErrorCheck
extends SlangDiagnosticCheck
implements Diagnostics {
    private List<Diagnostic> diagnostics;

    @Override
    public void setDiagnostics(List<Diagnostic> diagnostics) {
        this.diagnostics = diagnostics;
    }

    @Override
    public Set<String> ids() {
        return Set.of();
    }

    @Override
    public void retrieveIssues() {
        List<Diagnostic> diags = this.diagnostics.stream().filter(d -> d.severity() == Diagnostic.Severity.Error).toList();
        for (Diagnostic diagnostic : diags) {
            if (diagnostic.locationRange() != null) {
                this.issues().addPreciseIssue(diagnostic.locationRange(), this.message(diagnostic.message()), this.secondaryLocations(diagnostic.secondaryLocations()));
                continue;
            }
            this.issues().addLineIssue(diagnostic.location().file(), diagnostic.location().line(), this.message(diagnostic.message()), this.secondaryLocations(diagnostic.secondaryLocations()));
        }
    }
}

