/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.helpers;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Comments;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class CommentContainsPatternCheck
extends SlangCrossFileCheck
implements Comments {
    private final List<String> patterns;
    private final String message;
    private List<SyntaxNode.Trivia> comments;

    @Override
    public void setComments(List<SyntaxNode.Trivia> comments) {
        this.comments = comments;
    }

    protected CommentContainsPatternCheck(List<String> patterns, String message) {
        this.message = message;
        this.patterns = patterns;
    }

    @Override
    public void retrieveIssues() {
        for (SyntaxNode.Trivia comment : this.comments) {
            for (String pattern : this.patterns) {
                if (!StringUtils.containsIgnoreCase(comment.text(), pattern) || CommentContainsPatternCheck.isLetterAround(comment.text(), pattern)) continue;
                this.issues().addPreciseIssue(comment, this.message);
            }
        }
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase(line, pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }
}

