/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.BeginEndLabelled;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.BeginEndLabels;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG051")
public class BeginEndLabelsMatchCheck
extends SlangCrossFileCheck
implements BeginEndLabels,
FreeHdlDesignerCheck {
    private List<BeginEndLabelled> beginEndLabels;

    @Override
    public void setBeginEndLabels(List<BeginEndLabelled> beginEndLabels) {
        this.beginEndLabels = beginEndLabels;
    }

    @Override
    public void retrieveIssues() {
        for (BeginEndLabelled beginEndLabel : this.beginEndLabels) {
            if (beginEndLabel.identifier() == null || beginEndLabel.endLabel() == null || beginEndLabel.identifier().text().equals(beginEndLabel.endLabel().text())) continue;
            this.issues().addPreciseIssue(beginEndLabel.endLabel(), "Match the begin label.", List.of(new HdlIssueLocation(beginEndLabel.identifier(), "Label to repeat")));
        }
    }
}

