/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.GenericCaseStatement;
import com.lintyservices.slang.trees.StandardCaseItem;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.GenericCaseStatements;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VERILOG030")
public class CaseDifferentItemsCheck
extends SlangCrossFileCheck
implements GenericCaseStatements,
FreeHdlDesignerCheck {
    private List<GenericCaseStatement> caseStatements;

    @Override
    public void setGenericCaseStatements(List<GenericCaseStatement> caseStatements) {
        this.caseStatements = caseStatements;
    }

    @Override
    public void retrieveIssues() {
        for (GenericCaseStatement caseStatement : this.caseStatements) {
            Map<String, List<SyntaxNode>> expressionMap = caseStatement.standardCaseItems().stream().map(StandardCaseItem::expressions).flatMap(Collection::stream).collect(Collectors.groupingBy(SyntaxNode::text));
            expressionMap.forEach((k, v) -> {
                if (v.size() > 1) {
                    ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
                    for (int i = 1; i < v.size(); ++i) {
                        secondaryLocations.add(new HdlIssueLocation((SyntaxNode)v.get(i), "Same case item expression"));
                    }
                    this.issues().addPreciseIssue((SyntaxNode)v.get(0), "Fix this duplicated case item expression.", secondaryLocations);
                }
            });
        }
    }
}

