/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Comments;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG021")
public class CommentsStyleCheck
extends SlangCrossFileCheck
implements Comments,
HdlDesignerCheck {
    private List<SyntaxNode.Trivia> blockComments;

    @Override
    public void setComments(List<SyntaxNode.Trivia> comments) {
        this.blockComments = comments.stream().filter(c -> c.kind() == SyntaxNode.TriviaKind.BlockComment).toList();
    }

    @Override
    public void retrieveIssues() {
        for (SyntaxNode.Trivia comment : this.blockComments) {
            this.issues().addPreciseIssue(comment, "Use line comments (// ...) instead of block comments (/* ... */).");
        }
    }
}

