/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.DataDeclaration;
import com.lintyservices.slang.trees.Declarator;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.DataDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG065")
public class ConstantNamingConventionCheck
extends SlangCrossFileCheck
implements DataDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[A-Z]|[A-Z]+[A-Z0-9_]*[A-Z0-9]+$";
    private List<DataDeclaration> dataDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[A-Z]|[A-Z]+[A-Z0-9_]*[A-Z0-9]+$")
    public String format = "^[A-Z]|[A-Z]+[A-Z0-9_]*[A-Z0-9]+$";

    @Override
    public void setDataDeclarations(List<DataDeclaration> dataDeclarations) {
        this.dataDeclarations = dataDeclarations.stream().filter(d -> d.modifiers().stream().map(SyntaxNode::text).anyMatch(t -> t.equals("const"))).toList();
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (DataDeclaration dataDeclaration : this.dataDeclarations) {
            for (SyntaxNode identifier : dataDeclaration.declarators().stream().map(Declarator::identifier).toList()) {
                if (pattern.matcher(identifier.text()).matches()) continue;
                this.issues().addPreciseIssue(identifier, String.format("Rename constant '%s' to match the following regular expression: %s", identifier.text(), this.format));
            }
        }
    }
}

