/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.metrics.LinesOfCodesComputer;
import com.lintyservices.sonar.plugins.verilog.slang.data.AllTokensByFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;

@Rule(key="VERILOG005")
public class EmptyFileCheck
extends SlangCrossFileCheck
implements AllTokensByFile,
FreeHdlDesignerCheck {
    private Map<File, List<SyntaxNode>> allTokensByFile;

    @Override
    public void setAllTokensByFile(Map<File, List<SyntaxNode>> allTokensByFile) {
        this.allTokensByFile = allTokensByFile;
    }

    @Override
    public void retrieveIssues() {
        for (Map.Entry<File, List<SyntaxNode>> entry : this.allTokensByFile.entrySet()) {
            if (new LinesOfCodesComputer(entry.getValue()).getNumberOfLinesOfCode() != 0) continue;
            this.issues().addFileIssue(entry.getKey(), "Remove this empty file.");
        }
    }
}

