/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.DesignUnitDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.DesignUnitDeclarations;
import com.lintyservices.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG015")
public class FileNamingConventionCheck
extends SlangCrossFileCheck
implements DesignUnitDeclarations,
HdlDesignerCheck {
    private static final String COMMON_DESCRIPTION_ONE_SINGLE_UNIT_FORMAT = "See documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\n{DESIGN_UNIT} placeholder can be used in regular expression. For instance: ^{DESIGN_UNIT}[a-z_]*\\.(v|sv)$ means that the name of the file should start with the name of the design unit (module, interface, package, class, etc.) it defines and additional characters after the name of the design unit are allowed.";
    public static final String DEFAULT_FORMAT_SYNTHESIS_ONE_SINGLE_DESIGN_UNIT = "^{DESIGN_UNIT}\\.(v|sv)$";
    public static final String DEFAULT_FORMAT_SIMULATION_ONE_SINGLE_DESIGN_UNIT = "^{DESIGN_UNIT}\\.(v|sv)$";
    public static final String DEFAULT_FORMAT_SYNTHESIS_OTHERS = "^[a-z][a-z0-9_]*\\.(v|vh|sv|svh)$";
    public static final String DEFAULT_FORMAT_SIMULATION_OTHERS = "^[a-z][a-z0-9_]*\\.(v|vh|sv|svh)$";
    private Map<File, List<DesignUnitDeclaration>> unitMap;
    @RuleProperty(key="synthesisOneSingleUnitFormat", description="Regular expression for synthesis files defining one single design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\n{DESIGN_UNIT} placeholder can be used in regular expression. For instance: ^{DESIGN_UNIT}[a-z_]*\\.(v|sv)$ means that the name of the file should start with the name of the design unit (module, interface, package, class, etc.) it defines and additional characters after the name of the design unit are allowed.", type="REGULAR_EXPRESSION", defaultValue="^{DESIGN_UNIT}\\.(v|sv)$")
    public String synthesisOneSingleUnitFormat = "^{DESIGN_UNIT}\\.(v|sv)$";
    @RuleProperty(key="synthesisOthersFormat", description="Regular expression for synthesis files defining no design unit or more than one design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z][a-z0-9_]*\\.(v|vh|sv|svh)$")
    public String synthesisOthersFormat = "^[a-z][a-z0-9_]*\\.(v|vh|sv|svh)$";
    @RuleProperty(key="simulationOneSingleUnitFormat", description="Regular expression for simulation files defining one single design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com\n{DESIGN_UNIT} placeholder can be used in regular expression. For instance: ^{DESIGN_UNIT}[a-z_]*\\.(v|sv)$ means that the name of the file should start with the name of the design unit (module, interface, package, class, etc.) it defines and additional characters after the name of the design unit are allowed.", type="REGULAR_EXPRESSION", defaultValue="^{DESIGN_UNIT}\\.(v|sv)$")
    public String simulationOneSingleUnitFormat = "^{DESIGN_UNIT}\\.(v|sv)$";
    @RuleProperty(key="simulationOthersFormat", description="Regular expression for simulation files defining no design unit or more than one design unit.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z][a-z0-9_]*\\.(v|vh|sv|svh)$")
    public String simulationOthersFormat = "^[a-z][a-z0-9_]*\\.(v|vh|sv|svh)$";

    @Override
    public void setDesignUnitDeclarations(List<DesignUnitDeclaration> unitDeclarations) {
        this.unitMap = unitDeclarations.stream().collect(Collectors.groupingBy(d -> d.location().file()));
    }

    @Override
    public final void retrieveIssues() {
        for (File file : this.filesToAnalyze()) {
            Pattern pattern;
            String format;
            List<Object> units = new ArrayList();
            for (Map.Entry<File, List<DesignUnitDeclaration>> entry : this.unitMap.entrySet()) {
                if (!FileUtils.equals(entry.getKey(), file)) continue;
                units = entry.getValue();
                break;
            }
            if (units.size() == 1) {
                format = this.isSimulationFile(file) ? this.simulationOneSingleUnitFormat : this.synthesisOneSingleUnitFormat;
                format = format.replace("{DESIGN_UNIT}", ((DesignUnitDeclaration)units.get(0)).identifier().text());
            } else {
                format = this.isSimulationFile(file) ? this.simulationOthersFormat : this.synthesisOthersFormat;
            }
            if ((pattern = Pattern.compile(format, 32)).matcher(file.getName()).matches()) continue;
            this.issues().addFileIssue(file, String.format("Rename this file to match the following regular expression: %s", format));
        }
    }
}

