/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.FunctionDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.FunctionDeclarations;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG054")
public class FunctionAutomaticLifetimeCheck
extends SlangCrossFileCheck
implements FunctionDeclarations,
FreeHdlDesignerCheck {
    private List<FunctionDeclaration> functionDeclarations;

    @Override
    public void setFunctionDeclarations(List<FunctionDeclaration> functionDeclarations) {
        this.functionDeclarations = functionDeclarations;
    }

    @Override
    public void retrieveIssues() {
        for (FunctionDeclaration declaration : this.functionDeclarations) {
            if (this.isSimulationFile(declaration.keyword().location().file())) continue;
            if (declaration.lifetime() == null) {
                this.issues().addPreciseIssue(declaration.keyword(), "Add an \"automatic\" lifetime to this function declared in synthesizable code.");
                continue;
            }
            if ("automatic".equals(declaration.lifetime().text())) continue;
            this.issues().addPreciseIssue(declaration.lifetime(), "Change the lifetime to \"automatic\" for this function declared in synthesizable code.");
        }
    }
}

