/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxKind;
import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.trees.FunctionOrTaskDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.FunctionAndTaskDeclarations;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG052")
public class FunctionTaskLifetimeOutsideOfClassCheck
extends SlangCrossFileCheck
implements FunctionAndTaskDeclarations,
FreeHdlDesignerCheck {
    private List<FunctionOrTaskDeclaration> declarations;

    @Override
    public void setFunctionAndTaskDeclarations(List<FunctionOrTaskDeclaration> declarations) {
        this.declarations = declarations.stream().filter(d -> !d.node().hasAncestor(new SyntaxKind[]{SyntaxKinds.ClassDeclaration})).filter(d -> d.lifetime() == null).toList();
    }

    @Override
    public void retrieveIssues() {
        for (FunctionOrTaskDeclaration declaration : this.declarations) {
            this.issues().addPreciseIssue(declaration.keyword(), String.format("Add a lifetime (\"static\" or \"automatic\") to this %s that is declared outside of a class.", declaration.kind() == SyntaxKinds.TaskDeclaration ? "task" : "function"));
        }
    }
}

