/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.GenerateBlock;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.GenerateBlocks;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG044")
public class GenerateBlockLabelBeforeCheck
extends SlangCrossFileCheck
implements GenerateBlocks,
HdlDesignerCheck {
    private List<GenerateBlock> generateBlocks;

    @Override
    public void setGenerateBlocks(List<GenerateBlock> generateBlocks) {
        this.generateBlocks = generateBlocks;
    }

    @Override
    public void retrieveIssues() {
        this.generateBlocks.forEach(b -> {
            if (b.labelAfterBegin() != null && b.labelBeforeBegin() == null) {
                this.issues().addPreciseIssue(b.labelAfterBegin(), "Move this label right before the \"begin\" keyword.", List.of(new HdlIssueLocation(b.beginKeyword(), "begin keyword")));
            }
        });
    }
}

