/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.InterfaceDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.InterfaceDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG036")
public class InterfaceNamingConventionCheck
extends SlangCrossFileCheck
implements InterfaceDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private List<InterfaceDeclaration> interfaceDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$")
    private String format = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void setInterfaceDeclarations(List<InterfaceDeclaration> interfaceDeclarations) {
        this.interfaceDeclarations = interfaceDeclarations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        this.interfaceDeclarations.forEach(d -> {
            if (!pattern.matcher(d.identifier().text()).matches()) {
                this.issues().addPreciseIssue(d.identifier(), String.format("Rename this interface to match the following regular expression: %s", this.format));
            }
        });
    }
}

