/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ModuleDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG024")
public class ModuleNamingConventionCheck
extends SlangCrossFileCheck
implements ModuleDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private List<ModuleDeclaration> moduleDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$", type="REGULAR_EXPRESSION")
    public String format = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void setModuleDeclarations(List<ModuleDeclaration> moduleDeclarations) {
        this.moduleDeclarations = moduleDeclarations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (ModuleDeclaration declaration : this.moduleDeclarations) {
            if (pattern.matcher(declaration.identifier().text()).matches()) continue;
            this.issues().addPreciseIssue(declaration.identifier(), String.format("Rename module '%s' to match the following regular expression: %s", declaration.identifier().text(), this.format));
        }
    }
}

