/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.trees.HierarchyInstantiation;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ModuleDeclarations;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG060")
public class ModuleRecursiveInstantiationCheck
extends SlangCrossFileCheck
implements ModuleDeclarations,
HdlDesignerCheck {
    private List<ModuleDeclaration> moduleDeclarations;

    @Override
    public void setModuleDeclarations(List<ModuleDeclaration> moduleDeclarations) {
        this.moduleDeclarations = moduleDeclarations;
    }

    @Override
    public void retrieveIssues() {
        for (ModuleDeclaration moduleDeclaration : this.moduleDeclarations) {
            List<HierarchyInstantiation> recursiveInstantiations = moduleDeclaration.node().search(SyntaxKinds.HierarchyInstantiation).stream().map(HierarchyInstantiation::new).filter(i -> i.type().text().equals(moduleDeclaration.identifier().text())).toList();
            for (HierarchyInstantiation instantiation : recursiveInstantiations) {
                this.issues().addPreciseIssue(instantiation.type(), "Remove this recursive module instantiation.", List.of(new HdlIssueLocation(moduleDeclaration.identifier(), "Parent module")));
            }
        }
    }
}

