/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.NetDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.NetDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG016")
public class NetNamingConventionCheck
extends SlangCrossFileCheck
implements NetDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private List<NetDeclaration> netDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$", type="REGULAR_EXPRESSION")
    public String format = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void setNetDeclarations(List<NetDeclaration> netDeclarations) {
        this.netDeclarations = netDeclarations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (NetDeclaration declaration : this.netDeclarations) {
            for (SyntaxNode name : declaration.names()) {
                if (pattern.matcher(name.text()).matches()) continue;
                this.issues().addPreciseIssue(name, String.format("Rename this net to match the following regular expression: %s", this.format));
            }
        }
    }
}

