/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.ParameterDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ParameterDeclarations;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG080")
public class ParameterExplicitStorageTypeCheck
extends SlangCrossFileCheck
implements ParameterDeclarations,
HdlDesignerCheck {
    private static final String MESSAGE = "Add an explicit storage type.";
    private List<ParameterDeclaration> parameterDeclarations;

    @Override
    public void setParameterDeclarations(List<ParameterDeclaration> parameterDeclarations) {
        this.parameterDeclarations = parameterDeclarations;
    }

    @Override
    public void retrieveIssues() {
        for (ParameterDeclaration declaration : this.parameterDeclarations) {
            if (declaration.dataType() != null) continue;
            if (declaration.keyword() != null) {
                this.issues().addPreciseIssue(declaration.keyword(), MESSAGE);
                continue;
            }
            this.issues().addPreciseIssue(declaration, MESSAGE);
        }
    }
}

