/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.ImplicitNonAnsiPort;
import com.lintyservices.slang.trees.NonAnsiPortList;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.NonAnsiPortLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VERILOG097")
public class RepeatedNonAnsiPortCheck
extends SlangCrossFileCheck
implements NonAnsiPortLists,
FreeHdlDesignerCheck {
    private List<NonAnsiPortList> portLists = new ArrayList<NonAnsiPortList>();

    @Override
    public void setNonAnsiPortLists(List<NonAnsiPortList> portLists) {
        this.portLists = portLists;
    }

    @Override
    public void retrieveIssues() {
        for (NonAnsiPortList portList : this.portLists) {
            Map<String, List<ImplicitNonAnsiPort>> portsByName = portList.portIdentifiers().stream().collect(Collectors.groupingBy(p -> p.identifier().text()));
            for (Map.Entry<String, List<ImplicitNonAnsiPort>> entry : portsByName.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
                for (int i = 1; i < entry.getValue().size(); ++i) {
                    secondaryLocations.add(new HdlIssueLocation(entry.getValue().get(i).identifier(), "Duplicate"));
                }
                this.issues().addPreciseIssue(entry.getValue().get(0), "Remove those duplicated ports.", secondaryLocations);
            }
        }
    }
}

