/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.metrics.LinesOfCodesComputer;
import com.lintyservices.sonar.plugins.verilog.slang.data.AllTokensByFile;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG008")
public class TooManyLinesOfCodeInFileCheck
extends SlangCrossFileCheck
implements AllTokensByFile,
FreeHdlDesignerCheck {
    private static final int DEFAULT_MAXIMUM = 350;
    private Map<File, List<SyntaxNode>> allTokensByFile;
    @RuleProperty(key="max", description="Maximum number of lines of code in a file.", defaultValue="350")
    public int max = 350;

    @Override
    public void setAllTokensByFile(Map<File, List<SyntaxNode>> allTokensByFile) {
        this.allTokensByFile = allTokensByFile;
    }

    @Override
    public void retrieveIssues() {
        for (Map.Entry<File, List<SyntaxNode>> entry : this.allTokensByFile.entrySet()) {
            int lines = new LinesOfCodesComputer(entry.getValue()).getNumberOfLinesOfCode();
            if (lines <= this.max) continue;
            this.issues().addFileIssue(entry.getKey(), MessageFormat.format("This file has {0} lines of code, which is greater than {1} authorized. Split it into smaller files.", lines, this.max));
        }
    }
}

