/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.metrics.Comment;
import com.lintyservices.sonar.plugins.verilog.metrics.CommentLinesComputer;
import com.lintyservices.sonar.plugins.verilog.slang.data.AllTokensByFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;

@Rule(key="VERILOG012")
public class TrailingCommentsCheck
extends SlangCrossFileCheck
implements AllTokensByFile,
HdlDesignerCheck {
    private Map<File, List<SyntaxNode>> allTokensByFile;

    @Override
    public void setAllTokensByFile(Map<File, List<SyntaxNode>> allTokensByFile) {
        this.allTokensByFile = allTokensByFile;
    }

    @Override
    public void retrieveIssues() {
        for (Map.Entry<File, List<SyntaxNode>> entry : this.allTokensByFile.entrySet()) {
            new CommentLinesComputer(entry.getValue()).getComments().stream().filter(Comment::isTrailing).forEach(c -> this.issues().addPreciseIssue(c.location(), "Move the trailing comment to the previous line."));
        }
    }
}

