/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.TypedefDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.TypedefDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG018")
public class UserDefinedTypeNamingConventionCheck
extends SlangCrossFileCheck
implements TypedefDeclarations,
HdlDesignerCheck {
    public static final String DEFAULT_FORMAT_ENUM = "^[a-z]+[a-z0-9_]*_e$";
    public static final String DEFAULT_FORMAT_OTHER_TYPE = "^[a-z]+[a-z0-9_]*_t$";
    private List<TypedefDeclaration> typedefDeclarations;
    @RuleProperty(key="enum", description="Regular expression for enum types to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]+[a-z0-9_]*_e$")
    public String enumFormat = "^[a-z]+[a-z0-9_]*_e$";
    @RuleProperty(key="others", description="Regular expression for other types to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[a-z]+[a-z0-9_]*_t$")
    public String otherTypesFormat = "^[a-z]+[a-z0-9_]*_t$";

    @Override
    public void setTypedefDeclarations(List<TypedefDeclaration> typedefDeclarations) {
        this.typedefDeclarations = typedefDeclarations;
    }

    @Override
    public void retrieveIssues() {
        this.typedefDeclarations.forEach(t -> {
            String format = t.isEnumType() ? this.enumFormat : this.otherTypesFormat;
            Pattern pattern = Pattern.compile(format, 32);
            if (!pattern.matcher(t.identifier().text()).matches()) {
                this.issues().addPreciseIssue(t.identifier(), String.format("Rename user-defined type '%s' to match the following regular expression: %s", t.identifier().text(), format));
            }
        });
    }
}

