/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.trees.Directive;
import com.lintyservices.slang.trees.MacroUsage;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Directives;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG074")
public class UvmWarningMacroCheck
extends SlangCrossFileCheck
implements Directives,
HdlDesignerCheck {
    private List<MacroUsage> directives;

    @Override
    public void setDirectives(List<Directive> directives) {
        this.directives = directives.stream().filter(d -> d.kind() == SyntaxKinds.MacroUsage).map(d -> new MacroUsage(d.node())).toList();
    }

    @Override
    public void retrieveIssues() {
        for (MacroUsage directive : this.directives) {
            if (!"uvm_warning".equals(directive.directiveName())) continue;
            this.issues().addPreciseIssue(directive, "Use \"uvm_error\" or \"uvm_fatal\" instead.");
        }
    }
}

