/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.ImplicitAnsiPort;
import com.lintyservices.slang.trees.ImplicitNonAnsiPort;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.slang.trees.ParameterDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ImplicitAnsiPorts;
import com.lintyservices.sonar.plugins.verilog.slang.data.ImplicitNonAnsiPorts;
import com.lintyservices.sonar.plugins.verilog.slang.data.ModuleDeclarations;
import com.lintyservices.sonar.plugins.verilog.slang.data.ParameterDeclarations;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG070")
public class VhdlKeywordCheck
extends SlangCrossFileCheck
implements ModuleDeclarations,
ParameterDeclarations,
ImplicitAnsiPorts,
ImplicitNonAnsiPorts,
HdlDesignerCheck {
    public static final List<String> VHDL_KEYWORDS = List.of("abs", "access", "after", "alias", "all", "and", "architecture", "array", "assert", "assume", "assume_guarantee", "attribute", "begin", "block", "body", "buffer", "bus", "case", "component", "configuration", "constant", "context", "cover", "default", "disconnect", "downto", "else", "elsif", "end", "entity", "exit", "fairness", "file", "for", "force", "function", "generate", "generic", "group", "guarded", "if", "impure", "in", "inertial", "inout", "is", "label", "library", "linkage", "literal", "loop", "map", "mod", "nand", "new", "next", "nor", "not", "null", "of", "on", "open", "or", "others", "out", "package", "parameter", "port", "postponed", "procedure", "process", "property", "protected", "pure", "range", "record", "register", "reject", "release", "rem", "report", "restrict", "restrict_guarantee", "return", "rol", "ror", "select", "sequence", "severity", "shared", "signal", "sla", "sra", "srl", "strong", "subtype", "then", "to", "transport", "type", "unaffected", "units", "until", "use", "variable", "vmode", "vprop", "vunit", "wait", "when", "while", "with", "xnor", "xor");
    private List<ModuleDeclaration> moduleDeclarations;
    private List<ImplicitAnsiPort> ansiPorts;
    private List<ImplicitNonAnsiPort> nonAnsiPorts;
    private List<ParameterDeclaration> parameterDeclarations;

    @Override
    public void setModuleDeclarations(List<ModuleDeclaration> moduleDeclarations) {
        this.moduleDeclarations = moduleDeclarations;
    }

    @Override
    public void setImplicitAnsiPorts(List<ImplicitAnsiPort> ports) {
        this.ansiPorts = ports;
    }

    @Override
    public void setImplicitNonAnsiPorts(List<ImplicitNonAnsiPort> ports) {
        this.nonAnsiPorts = ports;
    }

    @Override
    public void setParameterDeclarations(List<ParameterDeclaration> parameterDeclarations) {
        this.parameterDeclarations = parameterDeclarations;
    }

    @Override
    public void retrieveIssues() {
        for (ModuleDeclaration moduleDeclaration : this.moduleDeclarations) {
            this.checkForIssue(moduleDeclaration.identifier());
        }
        for (ImplicitAnsiPort implicitAnsiPort : this.ansiPorts) {
            this.checkForIssue(implicitAnsiPort.identifier());
        }
        for (ImplicitNonAnsiPort implicitNonAnsiPort : this.nonAnsiPorts) {
            this.checkForIssue(implicitNonAnsiPort.identifier());
        }
        for (ParameterDeclaration parameterDeclaration : this.parameterDeclarations) {
            for (SyntaxNode name : parameterDeclaration.names()) {
                this.checkForIssue(name);
            }
        }
    }

    private void checkForIssue(SyntaxNode node) {
        if (VHDL_KEYWORDS.contains(node.text().toLowerCase())) {
            this.issues().addPreciseIssue(node, "Rename this identifier to not match a VHDL keyword.");
        }
    }
}

