/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.computers;

import com.lintyservices.slang.helpers.LocationRange;
import com.lintyservices.slang.helpers.SyntaxNode;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;

public class VerilogSyntaxHighlighterComputer {
    public static final Logger LOG = LoggerFactory.getLogger(VerilogSyntaxHighlighterComputer.class);

    public VerilogSyntaxHighlighterComputer(Map<File, List<SyntaxNode>> tokens, SensorContext context) {
        LOG.info("Syntax highlighting...");
        for (Map.Entry<File, List<SyntaxNode>> entry : tokens.entrySet()) {
            NewHighlighting highlighting = context.newHighlighting().onFile(context.fileSystem().inputFile(context.fileSystem().predicates().is(entry.getKey())));
            for (SyntaxNode token : entry.getValue()) {
                if (token.isKeywordToken() && !token.isPreprocessed()) {
                    this.highlightKeyword(highlighting, token);
                }
                for (SyntaxNode.Trivia comment : token.getComments()) {
                    this.highlightComments(highlighting, comment);
                }
                for (SyntaxNode directive : token.getDirectives()) {
                    this.highlightDirectives(highlighting, directive);
                }
            }
            highlighting.save();
        }
        LOG.info("Syntax highlighting: Done");
    }

    private void highlightKeyword(NewHighlighting highlighting, SyntaxNode node) {
        this.highlight(highlighting, node.location(), TypeOfText.KEYWORD_LIGHT);
    }

    private void highlightComments(NewHighlighting highlighting, SyntaxNode.Trivia trivia) {
        this.highlight(highlighting, trivia.location(), TypeOfText.STRING);
    }

    private void highlightDirectives(NewHighlighting highlighting, SyntaxNode node) {
        this.highlight(highlighting, node.location(), TypeOfText.ANNOTATION);
    }

    private void highlight(NewHighlighting highlighting, LocationRange location, TypeOfText typeOfText) {
        highlighting.highlight(location.line(), location.column() - 1, location.endLine(), location.endColumn() - 1, typeOfText);
    }
}

