/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.metrics;

import com.lintyservices.slang.helpers.LocationRange;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.verilog.metrics.CommentAnalyzer;
import java.util.HashSet;
import java.util.Set;

public class Comment {
    private static final CommentAnalyzer commentAnalyzer = new CommentAnalyzer();
    private final SyntaxNode.Trivia trivia;
    private final boolean isHeader;
    private final boolean isTrailing;

    public Comment(SyntaxNode.Trivia trivia, boolean isHeader, boolean isTrailing) {
        this.trivia = trivia;
        this.isHeader = isHeader;
        this.isTrailing = isTrailing;
    }

    public String actualText() {
        String processedText = this.trivia.text().replaceAll("^//", "").replaceAll("^/\\*", "").replaceAll("\\*/$", "").replace("\r\n", "\n").replace("\r", "\n").trim();
        StringBuilder trimmedText = new StringBuilder();
        for (String l : processedText.split("\n")) {
            trimmedText.append(l.trim()).append("\n");
        }
        return trimmedText.toString().trim();
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    public boolean isTrailing() {
        return this.isTrailing;
    }

    public boolean isBlank() {
        String[] lineContents = this.getLineContents();
        boolean blank = true;
        for (String lineContent : lineContents) {
            if (commentAnalyzer.isBlank(lineContent)) continue;
            blank = false;
            break;
        }
        return blank;
    }

    public Set<Integer> getLineNumbers() {
        String[] lineContents = this.getLineContents();
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        for (int i = this.trivia.location().line(); i < this.trivia.location().line() + lineContents.length; ++i) {
            lineNumbers.add(i);
        }
        return lineNumbers;
    }

    public LocationRange location() {
        return this.trivia.location();
    }

    private String[] getLineContents() {
        return commentAnalyzer.getContents(this.trivia.text()).split("(\r)?\n|\r", -1);
    }
}

