/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl;

import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public class VhdlProfiles
implements BuiltInQualityProfilesDefinition {
    private static final String LIGHT_LINT_CHECKS_PROFILE_NAME = "Light Lint Checks";
    static final String LIGHT_LINT_CHECKS_PROFILE_PATH = "/com/lintyservices/sonar/plugins/vhdl/checks/active/VHDL_Light_Lint_Checks.json";
    private static final String DEEP_CODE_CHECKS_PROFILE_NAME = "Deep Code Checks";
    private static final String DEEP_CODE_CHECKS_PROFILE_PATH = "/com/lintyservices/sonar/plugins/vhdl/checks/active/VHDL_Deep_Code_Checks.json";

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        this.defineLightLintChecksProfile(context);
        this.defineDeepCodeChecksProfile(context);
    }

    private void defineLightLintChecksProfile(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(LIGHT_LINT_CHECKS_PROFILE_NAME, "vhdl");
        BuiltInQualityProfileJsonLoader.load(profile, "vhdl", LIGHT_LINT_CHECKS_PROFILE_PATH);
        profile.setDefault(true);
        profile.done();
    }

    private void defineDeepCodeChecksProfile(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile profile = context.createBuiltInQualityProfile(DEEP_CODE_CHECKS_PROFILE_NAME, "vhdl");
        profile.setDefault(false);
        for (String rule : BuiltInQualityProfileJsonLoader.loadActiveKeysFromJsonProfile(DEEP_CODE_CHECKS_PROFILE_PATH)) {
            profile.activateRule("vhdl", rule);
        }
        profile.done();
    }
}

