/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder;

import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import java.io.File;

public record SignalDeclaration(GenericTreeFile<IdentifierTree> treeFile, String fullName) {
    public File file() {
        return this.treeFile.file();
    }

    public IdentifierTree tree() {
        return (IdentifierTree)this.treeFile.tree();
    }

    public String farRightName() {
        if (this.fullName.endsWith("[")) {
            String[] splitName = this.fullName.split("\\[");
            String farRightNameWithClosingBrace = splitName[splitName.length - 1];
            return farRightNameWithClosingBrace.substring(0, farRightNameWithClosingBrace.length() - 1);
        }
        String[] splitName = this.fullName.split("\\.");
        return splitName[splitName.length - 1];
    }

    public String farLeftName() {
        return this.fullName.split("[\\[.]")[0];
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.treeFile.hashCode();
        result = 31 * result + this.fullName.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignalDeclaration)) {
            return false;
        }
        SignalDeclaration t = (SignalDeclaration)o;
        return t.treeFile().equals(this.treeFile()) && t.fullName().equals(this.fullName());
    }
}

