/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsageComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Clock {
    private final GenericTreeFile<IdentifierTree> treeFile;
    private final EntityTreeFile entityTreeFile;
    private final Set<ClockDirection> directions;
    private final Set<Set<ClockUsage>> usage;
    private final List<List<? extends IssueLocationInterface>> usageAsFlows;
    private final Set<Object> sourceSignals;

    public Clock(GenericTreeFile<IdentifierTree> treeFile, EntityTreeFile entityTreeFile, Set<ClockDirection> directions, Set<Set<ClockUsage>> usage, Set<Object> sourceSignals) {
        this.treeFile = treeFile;
        this.entityTreeFile = entityTreeFile;
        this.directions = directions;
        this.usage = usage;
        this.sourceSignals = sourceSignals;
        this.usageAsFlows = this.usageAsFlows(usage);
    }

    public String name() {
        return ((IdentifierTree)this.treeFile.tree()).identifier().text();
    }

    public IdentifierTree tree() {
        return (IdentifierTree)this.treeFile.tree();
    }

    public File file() {
        return this.treeFile.file();
    }

    public EntityTreeFile entityTreeFile() {
        return this.entityTreeFile;
    }

    public Set<ClockDirection> directions() {
        return this.directions;
    }

    public Set<ClockUsage> usage() {
        return this.usage.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean hasRisingUsage() {
        return this.directions().contains((Object)ClockDirection.RISING);
    }

    public boolean hasFallingUsage() {
        return this.directions().contains((Object)ClockDirection.FALLING);
    }

    public Set<Object> sourceSignals() {
        return this.sourceSignals;
    }

    public List<List<? extends IssueLocationInterface>> usageAsFlows() {
        return this.usageAsFlows;
    }

    private List<List<? extends IssueLocationInterface>> usageAsFlows(Set<Set<ClockUsage>> allUsage) {
        ArrayList<List<? extends IssueLocationInterface>> allIssueLocations = new ArrayList<List<? extends IssueLocationInterface>>();
        ArrayList<HdlIssueLocation> sourceSignalLocations = new ArrayList<HdlIssueLocation>();
        for (Object object : this.sourceSignals) {
            if (object instanceof TreeFile) {
                GenericTreeFile t = (GenericTreeFile)object;
                sourceSignalLocations.add(new HdlIssueLocation(t.file(), (Tree)t.tree(), "Source signal"));
                continue;
            }
            if (!(object instanceof String)) continue;
            String s = (String)object;
            String[] splitSourceSignal = s.split("\\|");
            sourceSignalLocations.add(new HdlIssueLocation(this.file(), this.tree(), "Source signal (unavailable in source code): " + splitSourceSignal[0] + " (module: " + splitSourceSignal[1] + ")"));
        }
        allIssueLocations.add(sourceSignalLocations);
        for (Set set : allUsage) {
            List<HdlIssueLocation> issueLocations = set.stream().sorted(new ClockUsageComparator()).map(u -> new HdlIssueLocation(u.file(), u.tree(), "Usage" + (String)(u.edgeTransitionDirection() != null ? " (direction: " + u.edgeTransitionDirection().value() + ")" : ""))).sorted(Comparator.reverseOrder()).toList();
            allIssueLocations.add(issueLocations);
        }
        return allIssueLocations;
    }
}

