/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable;

import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enable;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.yosys.helpers.enable.EnablePolarity;
import java.io.File;
import javax.annotation.Nullable;

public class EnableUsage {
    private final GenericTreeFile<VhdlTree> treeFile;
    private final VhdlTree tree;
    private Enable parent;
    @Nullable
    private EnablePolarity polarity;

    public EnableUsage(GenericTreeFile<VhdlTree> treeFile, EnablePolarity polarity) {
        this.treeFile = treeFile;
        this.tree = (VhdlTree)treeFile.tree();
        this.polarity = polarity;
    }

    public EnableUsage(GenericTreeFile<VhdlTree> treeFile) {
        this.treeFile = treeFile;
        this.tree = (VhdlTree)treeFile.tree();
    }

    public GenericTreeFile<VhdlTree> treeFile() {
        return this.treeFile;
    }

    public VhdlTree tree() {
        return (VhdlTree)this.treeFile.tree();
    }

    public File file() {
        return this.treeFile.file();
    }

    public void setParent(Enable parent) {
        this.parent = parent;
    }

    public Enable parent() {
        return this.parent;
    }

    @Nullable
    public EnablePolarity polarity() {
        return this.polarity;
    }

    public boolean isYosysEnableUsage() {
        return this.polarity != null;
    }

    public boolean isEnableWayUsage() {
        return this.isYosysEnableUsage() || this.inComponentInstantiation() || this.inLeftHandSideOfSignalAssignment();
    }

    @Nullable
    public ProcessStatementTree processTree() {
        if (this.tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT) != null) {
            return (ProcessStatementTree)this.tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT);
        }
        return null;
    }

    public String name() {
        Object t = this.treeFile.tree();
        if (t instanceof IdentifierTree) {
            IdentifierTree i = (IdentifierTree)t;
            return i.text();
        }
        return ((VhdlTree)this.treeFile.tree()).toString();
    }

    private boolean inComponentInstantiation() {
        return this.tree.hasAncestor(VhdlTree.Kind.COMPONENT_INSTANTIATION_STATEMENT);
    }

    private boolean inLeftHandSideOfSignalAssignment() {
        return this.tree.hasAncestor(VhdlTree.Kind.TARGET);
    }
}

