/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.SignalDeclaration;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enable;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.EnableUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.EnableUsageComparator;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.yosys.helpers.enable.EnablePolarity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SimpleEnable
implements Enable {
    private final SignalDeclaration signalDeclaration;
    private final Set<EnablePolarity> polarities;
    private final Set<Set<EnableUsage>> usage;
    private final List<List<? extends IssueLocationInterface>> usageAsFlows;

    public SimpleEnable(SignalDeclaration signalDeclaration, Set<EnablePolarity> polarities, Set<Set<EnableUsage>> usage) {
        this.signalDeclaration = signalDeclaration;
        this.polarities = polarities;
        this.usage = usage;
        this.usageAsFlows = this.usageAsFlows(usage);
        usage.stream().flatMap(Collection::stream).forEach(u -> u.setParent(this));
    }

    public SignalDeclaration signalDeclaration() {
        return this.signalDeclaration;
    }

    public GenericTreeFile<IdentifierTree> treeFile() {
        return this.signalDeclaration.treeFile();
    }

    public String name() {
        return this.signalDeclaration.fullName();
    }

    public VhdlTree tree() {
        return (VhdlTree)this.signalDeclaration.treeFile().tree();
    }

    public File file() {
        return this.signalDeclaration.treeFile().file();
    }

    public Set<EnablePolarity> polarities() {
        return this.polarities;
    }

    public Set<EnableUsage> usage() {
        return this.usage.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean hasActiveHighPolarity() {
        return this.polarities.contains((Object)EnablePolarity.ACTIVE_HIGH);
    }

    public boolean hasActiveLowPolarity() {
        return this.polarities.contains((Object)EnablePolarity.ACTIVE_LOW);
    }

    public boolean hasBothPolarities() {
        return this.polarities.contains((Object)EnablePolarity.ACTIVE_HIGH) && this.polarities.contains((Object)EnablePolarity.ACTIVE_LOW);
    }

    public List<List<? extends IssueLocationInterface>> usageAsFlows() {
        return this.usageAsFlows;
    }

    private List<List<? extends IssueLocationInterface>> usageAsFlows(Set<Set<EnableUsage>> allUsage) {
        ArrayList<List<? extends IssueLocationInterface>> allIssueLocations = new ArrayList<List<? extends IssueLocationInterface>>();
        for (Set<EnableUsage> usage : allUsage) {
            List<HdlIssueLocation> issueLocations = usage.stream().sorted(new EnableUsageComparator()).map(u -> new HdlIssueLocation(u.file(), u.tree(), "Usage " + (String)(u.polarity() != null ? " (" + u.polarity().value() + ")" : ""))).sorted(Comparator.reverseOrder()).toList();
            allIssueLocations.add(issueLocations);
        }
        return allIssueLocations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleEnable)) {
            return false;
        }
        SimpleEnable e = (SimpleEnable)o;
        return e.signalDeclaration().equals(this.signalDeclaration) && e.polarities().equals(this.polarities);
    }

    public int hashCode() {
        int result = 0;
        for (EnablePolarity polarity : this.polarities) {
            result ^= polarity.hashCode();
        }
        result *= 31;
        result = 31 * result + this.signalDeclaration.hashCode();
        return result;
    }
}

