/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm;

import com.lintyservices.sonar.plugins.bugfinder.objects.fsm.FsmInterface;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysFsmTransition;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Fsm
implements FsmInterface {
    private final int id;
    private final String name;
    private final YosysLocation location;
    @Nullable
    private final GenericTreeFile<SubtypeIndicationTree> type;
    private final int numberOfStates;
    private final List<List<YosysSignal>> inputSignals;
    private final Set<YosysSignal> outputSignals;
    private final Set<YosysFsmTransition> transitions;
    private final Map<String, String> encodedStates;
    private final List<String> states;
    @Nullable
    private final String resetState;

    public Fsm(int id, String name, YosysLocation location, @Nullable GenericTreeFile<SubtypeIndicationTree> type, int numberOfStates, List<List<YosysSignal>> inputSignals, Set<YosysSignal> outputSignals, Set<YosysFsmTransition> transitions, Map<String, String> encodedStates, List<String> states, @Nullable String resetState) {
        this.id = id;
        this.name = name;
        this.location = location;
        this.type = type;
        this.numberOfStates = numberOfStates;
        this.inputSignals = inputSignals;
        this.outputSignals = outputSignals;
        this.transitions = transitions;
        this.encodedStates = encodedStates;
        this.states = states;
        this.resetState = resetState;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public YosysLocation location() {
        return this.location;
    }

    public String resetState() {
        return this.resetState;
    }

    @Nullable
    public GenericTreeFile<SubtypeIndicationTree> type() {
        return this.type;
    }

    public Set<YosysFsmTransition> transitions() {
        return this.transitions;
    }

    public Map<String, String> encodedStates() {
        return this.encodedStates;
    }

    public List<String> states() {
        return this.states;
    }

    public int numberOfStates() {
        return this.numberOfStates;
    }

    public int numberOfInputSignals() {
        return this.inputSignals.stream().flatMap(Collection::stream).collect(Collectors.toSet()).size();
    }

    public int numberOfOutputSignals() {
        return this.outputSignals.size();
    }

    public boolean belongsToFile(File file) {
        return FileUtils.equals(this.location.file(), file);
    }

    public List<List<YosysSignal>> inputSignals() {
        return this.inputSignals;
    }

    public List<YosysSignal> outputSignals() {
        return this.outputSignals.stream().sorted(Comparator.comparing(YosysSignal::name)).toList();
    }

    public List<YosysSignal> flattenedAndSortedInputSignals() {
        return this.inputSignals.stream().flatMap(Collection::stream).collect(Collectors.toSet()).stream().sorted(Comparator.comparing(YosysSignal::name)).toList();
    }

    public List<YosysSignal> controlInSignalsByTransition(YosysFsmTransition transition) {
        HashSet signals = new HashSet();
        for (int i = 0; i < transition.controlIn().length; ++i) {
            if (!Set.of(Integer.valueOf(0), Integer.valueOf(1)).contains(transition.controlIn()[i])) continue;
            signals.addAll(this.inputSignals().get(i));
        }
        return signals.stream().sorted(Comparator.comparing(YosysSignal::name)).toList();
    }
}

