/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset;

import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.reset.Reset;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import com.lintyservices.yosys.helpers.reset.ResetPolarity;
import com.lintyservices.yosys.helpers.reset.ResetType;
import java.io.File;
import javax.annotation.Nullable;

public class ResetUsage {
    private final GenericTreeFile<VhdlTree> treeFile;
    private final VhdlTree tree;
    private Reset parent;
    @Nullable
    private ResetPolarity polarity;
    @Nullable
    private ResetType type;

    public ResetUsage(GenericTreeFile<VhdlTree> treeFile, ResetPolarity polarity, ResetType type) {
        this.treeFile = treeFile;
        this.tree = (VhdlTree)treeFile.tree();
        this.polarity = polarity;
        this.type = type;
    }

    public ResetUsage(GenericTreeFile<VhdlTree> treeFile) {
        this.treeFile = treeFile;
        this.tree = (VhdlTree)treeFile.tree();
    }

    public GenericTreeFile<VhdlTree> treeFile() {
        return this.treeFile;
    }

    public VhdlTree tree() {
        return (VhdlTree)this.treeFile.tree();
    }

    public File file() {
        return this.treeFile.file();
    }

    public void setParent(Reset parent) {
        this.parent = parent;
    }

    public Reset parent() {
        return this.parent;
    }

    @Nullable
    public ResetPolarity polarity() {
        return this.polarity;
    }

    @Nullable
    public ResetType type() {
        return this.type;
    }

    public String name() {
        Object t = this.treeFile.tree();
        if (t instanceof IdentifierTree) {
            IdentifierTree t2 = (IdentifierTree)t;
            return t2.text();
        }
        return ((VhdlTree)this.treeFile.tree()).toString();
    }

    public boolean isYosysResetUsage() {
        return this.type != null;
    }

    public boolean isResetWayUsage() {
        return this.type != null || this.inProcessSensitivityList() || this.inComponentInstantiation() || this.inLeftHandSideOfSignalAssignment();
    }

    public boolean isNonResetWayUsage() {
        return !this.isResetWayUsage();
    }

    @Nullable
    public ProcessStatementTree processTree() {
        if (this.tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT) != null) {
            return (ProcessStatementTree)this.tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT);
        }
        return null;
    }

    private boolean inProcessSensitivityList() {
        return this.tree.hasAncestor(VhdlTree.Kind.SENSITIVITY_LIST) && this.tree.hasAncestor(VhdlTree.Kind.PROCESS_STATEMENT);
    }

    private boolean inComponentInstantiation() {
        return this.tree.hasAncestor(VhdlTree.Kind.COMPONENT_INSTANTIATION_STATEMENT);
    }

    private boolean inLeftHandSideOfSignalAssignment() {
        return this.tree.hasAncestor(VhdlTree.Kind.TARGET);
    }
}

