/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.tree;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssues;
import com.lintyservices.sonar.plugins.hdl.visitors.FileScannerContext;
import com.lintyservices.sonar.plugins.hdl.visitors.SingleFileCheck;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.vhdl.api.VhdlCheck;
import com.lintyservices.sonar.plugins.vhdl.api.tree.DoubleDispatchVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.yosys.objects.YosysLocation;
import java.io.File;
import java.util.List;
import org.sonar.check.Rule;

public abstract class VhdlDoubleDispatchVisitorCheck
extends DoubleDispatchVisitor
implements VhdlCheck,
SingleFileCheck<VhdlTree> {
    private final HdlIssues issues = new HdlIssues(this);

    @Override
    public HdlIssues scanFile(FileScannerContext<VhdlTree> context) {
        this.validateCheckParameters();
        this.issues.reset();
        this.scanTree(context);
        return this.issues;
    }

    @Override
    public HdlIssues issues() {
        return this.issues;
    }

    @Override
    public void validateCheckParameters() {
    }

    public static String paramsErrorMessage(Class<? extends VhdlDoubleDispatchVisitorCheck> clazz, String errorMessage) {
        return "Check vhdl:" + clazz.getAnnotation(Rule.class).key() + " : " + errorMessage;
    }

    public void addPreciseIssue(VhdlTree tree, String message) {
        this.issues.addPreciseIssue(this.context().file(), tree, message);
    }

    public void addPreciseIssue(File file, VhdlTree tree, String message) {
        this.issues.addPreciseIssue(file, tree, message);
    }

    public void addPreciseIssue(YosysLocation location, String message) {
        this.issues.addPreciseIssue(location, message);
    }

    public void addPreciseIssue(VhdlTree tree, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        this.issues.addPreciseIssue(this.context().file(), tree, message, secondaryLocations);
    }

    public void addPreciseIssue(File file, VhdlTree tree, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        this.issues.addPreciseIssue(file, tree, message, secondaryLocations);
    }

    public void addPreciseIssueWithFlows(VhdlTree tree, String message, List<List<? extends IssueLocationInterface>> flows) {
        this.issues.addPreciseIssueWithFlows(this.context().file(), tree, message, flows);
    }

    public void addPreciseIssueWithFlows(File file, VhdlTree tree, String message, List<List<? extends IssueLocationInterface>> flows) {
        this.issues.addPreciseIssueWithFlows(file, tree, message, flows);
    }

    public void addLineIssue(int line, String message) {
        this.issues.addLineIssue(this.context().file(), line, message);
    }

    public void addFileIssue(String message) {
        this.issues.addFileIssue(this.context().file(), message);
    }
}

