/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.tree;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.hdl.visitors.FileScannerContext;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.visitor.TreeVisitor;
import com.lintyservices.sonar.plugins.vhdl.model.TreeImpl;
import java.util.Set;

public abstract class VhdlSubscriptionVisitor
implements TreeVisitor<VhdlTree> {
    private FileScannerContext<VhdlTree> context;

    public abstract Set<VhdlTree.Kind> nodesToVisit();

    public void visitNode(VhdlTree tree) {
    }

    public void leaveNode(VhdlTree tree) {
    }

    public void visitFile(VhdlTree tree) {
    }

    public void leaveFile(VhdlTree tree) {
    }

    @Override
    public void scanTree(FileScannerContext<VhdlTree> context) {
        this.context = context;
        this.visitFile(context.tree());
        this.scanTree(context.tree());
        this.leaveFile(context.tree());
    }

    public void scanTree(VhdlTree tree) {
        this.visit(tree);
    }

    private void visit(VhdlTree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    private boolean isSubscribed(VhdlTree tree) {
        return this.nodesToVisit().contains(tree.kind());
    }

    private void visitChildren(VhdlTree tree) {
        TreeImpl treeImpl = (TreeImpl)tree;
        if (!treeImpl.isLeaf()) {
            for (VhdlTree next : treeImpl.getChildren()) {
                if (next == null) continue;
                this.visit(next);
            }
        }
    }

    @Override
    public FileScannerContext<VhdlTree> context() {
        Preconditions.checkState(this.context != null, "this#scanTree(context) should be called to initialised the context before accessing it");
        return this.context;
    }
}

