/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.api.treefile;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;

public abstract class TreeFile<T extends Tree> {
    private final T tree;
    private final File file;

    public TreeFile(T tree, File file) {
        this.tree = tree;
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public T tree() {
        return this.tree;
    }

    protected String path() {
        try {
            return this.file().getCanonicalPath();
        }
        catch (IOException e) {
            throw new LintyException("Cannot get canonical path for " + String.valueOf(this.file.getAbsoluteFile()), e);
        }
    }

    public HdlIssueLocation location() {
        return new HdlIssueLocation(this.file, this.tree.line(), this.tree.column(), this.tree.endLine(), this.tree.endColumn());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeFile)) {
            return false;
        }
        TreeFile t = (TreeFile)o;
        return t.tree().equals(this.tree()) && FileUtils.equals(t.file(), this.file);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.file.hashCode();
        result = 31 * result + this.tree.hashCode();
        return result;
    }
}

