/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlCrossFileVerificLogCheck;
import com.lintyservices.yosys.objects.VerificLogItem;
import org.sonar.check.Rule;

@Rule(key="VHDL1074")
public class AssertionWarningCheck
extends VhdlCrossFileVerificLogCheck {
    @Override
    public final void retrieveIssues() {
        for (VerificLogItem item : this.filteredItems("VHDL-1811")) {
            String message;
            if (item.message().contains("Warning: ") && item.message().split("Warning:").length >= 2) {
                message = String.format("Review this assertion failing as warning: %s", item.message().split("Warning:")[1].trim());
            } else {
                message = item.message();
                this.logMessageCannotBeCustomized("VHDL1074", item);
            }
            this.issues().addPreciseIssue(item.location(), message);
        }
    }
}

