/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysSignal;
import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1070")
public class ClockDomainNameNoFrequencyCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private Clocks clocks;
    private Set<File> filesToAnalyze;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = (Clocks)clocks;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        Set clockSignalsToCheck = this.clocks.sourceSignals().stream().filter(c -> c.location() != null && FileUtils.contains(this.filesToAnalyze, c.location().file())).collect(Collectors.toSet());
        for (YosysSignal clockSignal : clockSignalsToCheck) {
            if (!clockSignal.name().matches("^.*\\d+.*$")) continue;
            this.issues().addPreciseIssue(clockSignal.location(), "Remove frequency information from this clock signal.");
        }
    }
}

