/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.SimpleEnable;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1042")
public class EnableNamingConventionCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderEnablesAwareVisitor {
    private static final String DEFAULT_FORMAT = "^([a-z\\d_]+_enable)|enable$";
    private Set<SimpleEnable> enables;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^([a-z\\d_]+_enable)|enable$")
    public String format = "^([a-z\\d_]+_enable)|enable$";

    @Override
    public void setEnables(EnablesInterface enables) {
        this.enables = ((Enables)enables).allSimpleEnables();
    }

    @Override
    public final void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (SimpleEnable enable : this.enables) {
            if (pattern.matcher(enable.signalDeclaration().farRightName()).matches()) continue;
            this.issues().addPreciseIssueWithFlows(enable.file(), enable.tree(), MessageFormat.format("Rename this \"{0}\" enable signal to match the following regular expression: {1}", enable.signalDeclaration().farRightName(), this.format), enable.usageAsFlows());
        }
    }
}

