/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EnumerationTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="VHDL1005")
public class FsmEnumeratedTypeCheck
extends VhdlBugFinderCheck
implements BugFinderFsmsAwareVisitor,
SubtypeTreeFileAwareVisitor,
TypeTreeFileAwareVisitor {
    private static final String ISSUE_MESSAGE = "Update this FSM to use an enumerated type.";
    private Fsms fsms;
    private Set<Fsm> fsmsInCurrentFile;
    private Set<TypeTreeFile> enumerations = new HashSet<TypeTreeFile>();
    private Set<SubtypeTreeFile> subtypes = new HashSet<SubtypeTreeFile>();

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public void setTypes(Set<TypeTreeFile> types) {
        this.enumerations = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof EnumerationTypeDefinitionTree).collect(Collectors.toSet());
    }

    @Override
    public void setSubtypes(Set<SubtypeTreeFile> subtypes) {
        this.subtypes = subtypes;
    }

    @Override
    public void visitDesignFile(DesignFileTree tree) {
        if (this.isBugfinderEnabled() && this.context().isSynthesisFile()) {
            this.fsmsInCurrentFile = this.fsms.fsms().stream().filter(f -> f.belongsToFile(this.context().file())).collect(Collectors.toSet());
            super.visitDesignFile(tree);
        }
    }

    @Override
    public void visitSignalDeclaration(SignalDeclarationTree tree) {
        for (IdentifierTree identifier : tree.identifiers()) {
            this.fsmsInCurrentFile.stream().filter(f -> f.name().equalsIgnoreCase(identifier.text())).findFirst().ifPresent(f -> this.checkForIssue((Fsm)f, tree, identifier));
        }
        super.visitSignalDeclaration(tree);
    }

    private void checkForIssue(Fsm fsm, SignalDeclarationTree tree, IdentifierTree identifier) {
        if (fsm.type() == null) {
            return;
        }
        List<TreeFile> typeFlow = this.buildTypeFlow(((SubtypeIndicationTree)fsm.type().tree()).typeName().firstToken().text());
        if (typeFlow.isEmpty()) {
            this.addPreciseIssue(identifier, ISSUE_MESSAGE, List.of(new HdlIssueLocation(tree.subtypeIndication(), "Type")));
        } else {
            TreeFile leaf = typeFlow.get(typeFlow.size() - 1);
            if (!(leaf.tree() instanceof FullTypeDeclarationTree)) {
                this.addPreciseIssueWithFlows(identifier, ISSUE_MESSAGE, List.of(typeFlow.stream().map(s -> new HdlIssueLocation(s.file(), ((SubtypeDeclarationTree)s.tree()).subtypeIndication(), "Related type")).toList()));
            }
        }
    }

    private List<TreeFile> buildTypeFlow(String type) {
        ArrayList<TreeFile> typeTreeStack = new ArrayList<TreeFile>();
        while (true) {
            TypeTreeFile typeTreeFile;
            if ((typeTreeFile = this.relatedEnumerationTypeTreeFile(type)) != null) {
                typeTreeStack.add(typeTreeFile);
                break;
            }
            SubtypeTreeFile subtypeTreeFile = this.relatedSubtypeTreeFile(type);
            if (subtypeTreeFile == null) break;
            typeTreeStack.add(subtypeTreeFile);
            type = ((SubtypeDeclarationTree)subtypeTreeFile.tree()).subtypeIndication().typeName().firstToken().text();
        }
        return typeTreeStack;
    }

    @Nullable
    private TypeTreeFile relatedEnumerationTypeTreeFile(String type) {
        return this.enumerations.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).identifier().text().equals(type)).findFirst().orElse(null);
    }

    @Nullable
    private SubtypeTreeFile relatedSubtypeTreeFile(String subtype) {
        return this.subtypes.stream().filter(s -> ((SubtypeDeclarationTree)s.tree()).identifier().text().equals(subtype)).findFirst().orElse(null);
    }
}

