/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.GenericTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFileComparator;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.EnumerationLiteralTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EnumerationTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeIndicationTree;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VHDL1039")
public class FsmStateNamingConventionCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor,
SubtypeTreeFileAwareVisitor,
TypeTreeFileAwareVisitor {
    private static final String DEFAULT_FORMAT = "^[A-Z]+[A-Z\\d]*$";
    private Fsms fsms;
    private List<TypeTreeFile> enumerations = new ArrayList<TypeTreeFile>();
    private List<SubtypeTreeFile> subtypes = new ArrayList<SubtypeTreeFile>();
    @RuleProperty(key="format", description="Regular expression to match for states.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[A-Z]+[A-Z\\d]*$")
    private String format = "^[A-Z]+[A-Z\\d]*$";

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public void setTypes(Set<TypeTreeFile> types) {
        this.enumerations = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof EnumerationTypeDefinitionTree).sorted(new TreeFileComparator()).toList();
    }

    @Override
    public void setSubtypes(Set<SubtypeTreeFile> subtypes) {
        this.subtypes = subtypes.stream().sorted(new TreeFileComparator()).toList();
    }

    @Override
    public final void retrieveIssues() {
        HashSet states = new HashSet();
        for (Fsm fsm : this.fsms.fsms()) {
            TreeFile leaf;
            List<TreeFile> typeFlow;
            if (fsm.type() == null || (typeFlow = this.buildTypeFlow(((SubtypeIndicationTree)fsm.type().tree()).typeName().firstToken().text()).stream().sorted(new TreeFileComparator()).toList()).isEmpty() || !((leaf = typeFlow.get(typeFlow.size() - 1)).tree() instanceof FullTypeDeclarationTree)) continue;
            ((EnumerationTypeDefinitionTree)((FullTypeDeclarationTree)leaf.tree()).typeDefinition()).literals().forEach(s -> states.add(new GenericTreeFile<EnumerationLiteralTree>((EnumerationLiteralTree)s, leaf.file())));
        }
        this.checkForIssues(states.stream().sorted(new TreeFileComparator()).toList());
    }

    private List<TreeFile<? extends VhdlTree>> buildTypeFlow(String type) {
        ArrayList<TreeFile<? extends VhdlTree>> typeTreeStack = new ArrayList<TreeFile<? extends VhdlTree>>();
        while (true) {
            TypeTreeFile typeTreeFile;
            if ((typeTreeFile = this.relatedEnumerationTypeTreeFile(type)) != null) {
                typeTreeStack.add(typeTreeFile);
                break;
            }
            SubtypeTreeFile subtypeTreeFile = this.relatedSubtypeTreeFile(type);
            if (subtypeTreeFile == null) break;
            typeTreeStack.add(subtypeTreeFile);
            type = ((SubtypeDeclarationTree)subtypeTreeFile.tree()).subtypeIndication().typeName().firstToken().text();
        }
        return typeTreeStack;
    }

    @Nullable
    private TypeTreeFile relatedEnumerationTypeTreeFile(String type) {
        return this.enumerations.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).identifier().text().equals(type)).min(new TreeFileComparator()).orElse(null);
    }

    @Nullable
    private SubtypeTreeFile relatedSubtypeTreeFile(String subtype) {
        return this.subtypes.stream().filter(s -> ((SubtypeDeclarationTree)s.tree()).identifier().text().equals(subtype)).min(new TreeFileComparator()).orElse(null);
    }

    private void checkForIssues(List<TreeFile<EnumerationLiteralTree>> states) {
        TreeMap<File, List<TreeFile>> statesByFile = new TreeMap<File, List<TreeFile>>(states.stream().collect(Collectors.groupingBy(TreeFile::file)));
        for (Map.Entry entry : statesByFile.entrySet()) {
            Set statesAsSet = ((List)entry.getValue()).stream().map(TreeFile::tree).collect(Collectors.toSet());
            for (EnumerationLiteralTree st : statesAsSet) {
                if (Pattern.compile(this.format, 32).matcher(st.toString()).matches()) continue;
                this.issues().addPreciseIssue((File)entry.getKey(), st, String.format("Rename this state to match the following regular expression: %s", this.format));
            }
        }
    }
}

