/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SignalTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.SubtypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.TypeTreeFile;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SignalTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.SubtypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.treefile.TypeTreeFileAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.parser.EnumerationLiteralTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EnumerationTypeDefinitionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.FullTypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SignalDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.SubtypeDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.TypeDefinitionTree;
import com.lintyservices.utils.FileUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;

@Rule(key="VHDL1040")
public class FsmStatesTypeStatesCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor,
SubtypeTreeFileAwareVisitor,
TypeTreeFileAwareVisitor,
SignalTreeFileAwareVisitor {
    private Fsms fsms;
    private Set<TypeTreeFile> enumerations = new HashSet<TypeTreeFile>();
    private Set<SubtypeTreeFile> subtypes = new HashSet<SubtypeTreeFile>();
    private Set<SignalTreeFile> signalDeclarations = new HashSet<SignalTreeFile>();

    @Override
    public void setSignals(Set<SignalTreeFile> signals) {
        this.signalDeclarations = signals;
    }

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public void setTypes(Set<TypeTreeFile> types) {
        this.enumerations = types.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).typeDefinition() instanceof EnumerationTypeDefinitionTree).collect(Collectors.toSet());
    }

    @Override
    public void setSubtypes(Set<SubtypeTreeFile> subtypes) {
        this.subtypes = subtypes;
    }

    @Override
    public final void retrieveIssues() {
        for (Fsm fsm : this.fsms.fsms()) {
            TypeDefinitionTree typeStates;
            List<EnumerationLiteralTree> typeStatesAsList;
            TreeFile<? extends VhdlTree> leaf;
            List<TreeFile<? extends VhdlTree>> typeFlow;
            SignalTreeFile signalDeclaration = this.relatedFsmSignalDeclaration(fsm);
            if (signalDeclaration == null || (typeFlow = this.buildTypeFlow(((SignalDeclarationTree)signalDeclaration.tree()).subtypeIndication().typeName().firstToken().text())).isEmpty() || !((leaf = typeFlow.get(typeFlow.size() - 1)).tree() instanceof FullTypeDeclarationTree) || (typeStatesAsList = ((EnumerationTypeDefinitionTree)(typeStates = ((FullTypeDeclarationTree)leaf.tree()).typeDefinition())).literals()).size() == fsm.numberOfStates()) continue;
            this.issues().addPreciseIssue(fsm.location(), String.format("FSM number of states (%d) does not match type number of states (%d).", fsm.numberOfStates(), typeStatesAsList.size()), List.of(new HdlIssueLocation(leaf.file(), typeStates, "Type states")));
        }
    }

    private List<TreeFile<? extends VhdlTree>> buildTypeFlow(String type) {
        ArrayList<TreeFile<? extends VhdlTree>> typeTreeStack = new ArrayList<TreeFile<? extends VhdlTree>>();
        while (true) {
            TypeTreeFile typeTreeFile;
            if ((typeTreeFile = this.relatedTypeTreeFile(type)) != null) {
                typeTreeStack.add(typeTreeFile);
                break;
            }
            SubtypeTreeFile subtypeTreeFile = this.relatedSubtypeTreeFile(type);
            if (subtypeTreeFile == null) break;
            typeTreeStack.add(subtypeTreeFile);
            type = ((SubtypeDeclarationTree)subtypeTreeFile.tree()).subtypeIndication().typeName().firstToken().text();
        }
        return typeTreeStack;
    }

    @Nullable
    private TypeTreeFile relatedTypeTreeFile(String type) {
        return this.enumerations.stream().filter(t -> ((FullTypeDeclarationTree)t.tree()).identifier().text().equals(type)).findFirst().orElse(null);
    }

    @Nullable
    private SubtypeTreeFile relatedSubtypeTreeFile(String subtype) {
        return this.subtypes.stream().filter(s -> ((SubtypeDeclarationTree)s.tree()).identifier().text().equals(subtype)).findFirst().orElse(null);
    }

    private SignalTreeFile relatedFsmSignalDeclaration(Fsm fsm) {
        return this.signalDeclarations.stream().filter(s -> FileUtils.equals(fsm.location().file(), s.file())).filter(s -> ((SignalDeclarationTree)s.tree()).identifiers().stream().map(IdentifierTree::text).collect(Collectors.toSet()).contains(fsm.name())).findFirst().orElse(null);
    }
}

