/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.VhdlBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import org.sonar.check.Rule;

@Rule(key="VHDL1036")
public class IfNoElseCombinationalProcessCheck
extends VhdlBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private Clocks clocks;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = (Clocks)clocks;
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (this.isBugfinderEnabled() && this.context().isSynthesisFile() && tree.elseStatements() == null && tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT) != null && this.clocks.isCombinationalProcess(this.context().file(), (ProcessStatementTree)tree.ancestor(VhdlTree.Kind.PROCESS_STATEMENT))) {
            this.addPreciseIssue(tree.ifKeyword(), "Add an \"else\" statement to this \"if\" statement.");
        }
        super.visitIfStatement(tree);
    }
}

