/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1015")
public class MultipleClockEdgeTransitionDirectionInSameProcessCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private Set<Clock> clocks;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = ((Clocks)clocks).clocks();
    }

    @Override
    public final void retrieveIssues() {
        for (Clock clock : this.clocks) {
            Map<File, Map<ProcessStatementTree, List<ClockUsage>>> allUsageByFileAndByProcessTree = this.allClockUsagePerFileAndPerProcess(clock);
            for (Map.Entry<File, Map<ProcessStatementTree, List<ClockUsage>>> entryFile : allUsageByFileAndByProcessTree.entrySet()) {
                File file = entryFile.getKey();
                for (Map.Entry<ProcessStatementTree, List<ClockUsage>> entryProcess : entryFile.getValue().entrySet()) {
                    long numberOfDirections = entryProcess.getValue().stream().map(ClockUsage::edgeTransitionDirection).distinct().count();
                    if (numberOfDirections <= 1L) continue;
                    ArrayList<List<? extends IssueLocationInterface>> flow = new ArrayList<List<? extends IssueLocationInterface>>();
                    flow.add(entryProcess.getValue().stream().map(u -> new HdlIssueLocation(u.file(), u.tree(), "Usage (direction: " + u.edgeTransitionDirection().value() + ")")).sorted(Comparator.reverseOrder()).toList());
                    this.issues().addPreciseIssueWithFlows(file, entryProcess.getKey().beginStatementKeyword(), "Split this process to only keep one edge transition direction per clock.", flow);
                }
            }
        }
    }

    private Map<File, Map<ProcessStatementTree, List<ClockUsage>>> allClockUsagePerFileAndPerProcess(Clock clock) {
        Map<File, List<ClockUsage>> allUsageByFile = clock.usage().stream().filter(u -> u.edgeTransitionDirection() != null).collect(Collectors.groupingBy(ClockUsage::file));
        HashMap<File, Map<ProcessStatementTree, List<ClockUsage>>> allUsageByFileAndByProcess = new HashMap<File, Map<ProcessStatementTree, List<ClockUsage>>>();
        for (Map.Entry<File, List<ClockUsage>> entry : allUsageByFile.entrySet()) {
            allUsageByFileAndByProcess.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(ClockUsage::processTree)));
        }
        return allUsageByFileAndByProcess;
    }
}

