/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.clock.ClocksInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderClocksAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clock;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.ClockUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.clock.Clocks;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.parser.ProcessStatementTree;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1014")
public class MultipleClockUsageInSameProcessCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderClocksAwareVisitor {
    private Set<Clock> clocks;

    @Override
    public void setClocks(ClocksInterface clocks) {
        this.clocks = ((Clocks)clocks).clocks();
    }

    @Override
    public final void retrieveIssues() {
        Map<File, Map<ProcessStatementTree, List<ClockUsage>>> allUsageByFileAndByProcessTree = this.allClockUsagePerFileAndPerProcess();
        for (File file : allUsageByFileAndByProcessTree.keySet()) {
            for (ProcessStatementTree processStatementTree : allUsageByFileAndByProcessTree.get(file).keySet()) {
                Map<String, List<ClockUsage>> usageByClockName = allUsageByFileAndByProcessTree.get(file).get(processStatementTree).stream().collect(Collectors.groupingBy(ClockUsage::name));
                String clockNames = allUsageByFileAndByProcessTree.get(file).get(processStatementTree).stream().map(ClockUsage::name).distinct().sorted().collect(Collectors.joining(", "));
                if (usageByClockName.keySet().size() <= 1) continue;
                ArrayList<List<? extends IssueLocationInterface>> flow = new ArrayList<List<? extends IssueLocationInterface>>();
                for (Map.Entry<String, List<ClockUsage>> entry : usageByClockName.entrySet()) {
                    flow.add(entry.getValue().stream().map(u -> new HdlIssueLocation(u.file(), u.tree(), "Usage")).sorted(Comparator.reverseOrder()).toList());
                }
                this.issues().addPreciseIssueWithFlows(file, processStatementTree.beginStatementKeyword(), "Split this process to only keep one clock. Clock signals: " + clockNames, flow);
            }
        }
    }

    private Map<File, Map<ProcessStatementTree, List<ClockUsage>>> allClockUsagePerFileAndPerProcess() {
        Map<File, List<ClockUsage>> allUsageByFile = this.clocks.stream().map(Clock::usage).flatMap(Collection::stream).filter(u -> u.inProcessBody() || u.inProcessSensitivityList()).collect(Collectors.groupingBy(ClockUsage::file));
        HashMap<File, Map<ProcessStatementTree, List<ClockUsage>>> allUsageByFileAndByProcess = new HashMap<File, Map<ProcessStatementTree, List<ClockUsage>>>();
        for (Map.Entry<File, List<ClockUsage>> entry : allUsageByFile.entrySet()) {
            allUsageByFileAndByProcess.put(entry.getKey(), entry.getValue().stream().collect(Collectors.groupingBy(ClockUsage::processTree)));
        }
        return allUsageByFileAndByProcess;
    }
}

