/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.vhdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.enable.EnablesInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderEnablesAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.EnableUsage;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.Enables;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.enable.SimpleEnable;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.visitors.VhdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.vhdl.model.VhdlInternalSyntaxToken;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VHDL1046")
public class NonEnableUsageCheck
extends VhdlCrossFileBugFinderCheck
implements BugFinderEnablesAwareVisitor {
    private Set<SimpleEnable> enables;

    @Override
    public void setEnables(EnablesInterface enables) {
        this.enables = ((Enables)enables).allSimpleEnables();
    }

    @Override
    public final void retrieveIssues() {
        for (SimpleEnable enable : this.enables) {
            this.issues().addPreciseIssues(enable.usage().stream().filter(usage -> ((VhdlInternalSyntaxToken)usage.tree().firstToken()).isSynthesized()).filter(usage -> !usage.isEnableWayUsage()).map(usage -> {
                ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
                secondaryLocations.add(new HdlIssueLocation(enable.file(), enable.tree(), "Enable signal"));
                secondaryLocations.addAll(enable.usage().stream().filter(EnableUsage::isYosysEnableUsage).map(u -> new HdlIssueLocation(u.file(), u.tree(), "Usage as enable")).toList());
                return new PreciseIssue(this, new HdlIssueLocation(usage.file(), usage.tree(), "Remove this non-enable usage of the '" + enable.name() + "' enable signal."), secondaryLocations);
            }).collect(Collectors.toSet()));
        }
    }
}

